PROGRAM Main
VAR

(* Variables de MAESTRO por MODBUS RTU *)

inst1_MODBUS_MASTER_INIT: MODBUS_MASTER_INIT; 			(* Inicializa el Maestro por Modbus RTU *)
inst2_MODBUS_MASTER_CTRL: MODBUS_MASTER_CTRL; 			(* Recibe datos del Maestro por Modbus RTU *)

 	
	RTU_init: bool:= false; 							(* Se utiliza para inicializar el Maestro una sola vez *)
	mCtrl: bool:= false; 								(* Va alternando entre true y false para habilitar o deshabilitar la ejecución y no saturarla *)
	 
	mErrorRTU: usint; 									(* Mensaje de error de inicialización o ejecución del Maestro *)
	mDone: bool:= false; 								(* Nos indica si la ejecución ha finalizado *)
	
	modbusBuf: ARRAY[0..50] OF word; 					(* Array de bytes donde almacenaremos los datos del anemómetro *)
		data_Ptr: POINTER; 								(* Puntero que apuntará al flujo de datos del Maestro *)
 
	err: usint; 										(* Almacena el valor del error mErrorRTU *)


 
(* Variables de ESCLAVO por MODBUS TCP *)

inst1_MODBUS_TCP_SLAVE_INIT: MODBUS_TCP_SLAVE_INIT; 	(* Inicializa el Esclavo por Modbus TCP *)
inst2_MODBUS_TCP_SLAVE_CTRL: MODBUS_TCP_SLAVE_CTRL;		(* Escribe datos en el Esclavo  por Modbus TCP *)


	TCP_init: bool:= false;								(* Se utiliza para inicializar el Esclavo una sola vez *)
	
	mConfirmTCP: bool; 									(* Nos indica si la inicialización del Esclavo ha finalizado *)
	mErrorTCP: usint; 									(* Mensaje de error de inicialización del Esclavo *)
	mErrorinfoTCP: usint; 								(* Mensaje de error de inicialización del Esclavo *)
	
	xDone: bool;										(* Nos indica si la ejecución ha finalizado *)
	xError: usint;										(* Mensaje de error de inicialización o ejecución del Maestro *)
		

	modbusAIBuf: ARRAY[0..47] OF word; 					(* Array de words donde almacenaremos los registros de lectura como Input Registers *)
		AI_Ptr: POINTER;								(* Puntero que apunta al array de words de lectura *)
	modbusRegBuf: ARRAY[0..24] OF byte; 				(* Array de bytes donde almacenaremos los registros de escritura como Holding Registers *)
		Reg_Ptr: POINTER;								(* Puntero que apunta al array de bytes de escritura *)
	
	alpha: real;										(* Variables utilizadas para el filtro *)
	alpha_1: real;
	filtro: ARRAY[0..5] OF real;						(* Array de reals donde almacenaremos los valores filtrados de la velocidad de viento *)
								
	i: int:= 0;											(* Varibles utilizadas en bucles for *)
	j: int:= 1;
	
	Warning_Wind_Speed_OK: word;						(* Indicará el estado de la señal de Warning *)
	Alarm_Wind_Speed_OK: word;							(* Indicará el estado de la señal de Alarma *)
		
	Status_Register: word;								(* Status Register del PLC que nos indica a modo de flag el estado de la comunicación con el PLC *)

	
	DI_Modulo1 at %I0.0: byte;							(* 8 módulos de entradas digitales *)
	DI_Modulo2 at %I1.0: byte;
	DI_Modulo3 at %I2.0: byte;
	DI_Modulo4 at %I3.0: byte;
	DI_Modulo5 at %I4.0: byte;
	DI_Modulo6 at %I5.0: byte;
	DI_Modulo7 at %I6.0: byte;
	DI_Modulo8 at %I7.0: byte;
	
	DO_Modulo1 at %Q0.0: byte;							(* 12 módulos de salidas digitales *)
	DO_Modulo2 at %Q1.0: byte;
	DO_Modulo3 at %Q2.0: byte;
	DO_Modulo4 at %Q3.0: byte;
	DO_Modulo5 at %Q4.0: byte;
	DO_Modulo6 at %Q5.0: byte;
	DO_Modulo7 at %Q6.0: byte;
	DO_Modulo8 at %Q7.0: byte;
	DO_Modulo9 at %Q8.0: byte;
	DO_Modulo10 at %Q9.0: byte;
	DO_Modulo11 at %Q10.0: byte;
	DO_Modulo12 at %Q11.0: byte;
	
	DI_Word_aux1: word;									(* Variables auxiliares para pasar dos módulos de entradas digitales a un solo word *)
	DI_Word_aux2: word;
	DI_Word_aux3: word;
	DI_Word_aux4: word;
	DI_Word_aux5: word;
	DI_Word_aux6: word;
	DI_Word_aux7: word;
	DI_Word_aux8: word;
	DI_Word1: word;
	DI_Word2: word;
	DI_Word3: word;
	DI_Word4: word;
	
	
	DO_Byte1: byte;										(* Variables auxiliares para pasar dos módulos de salidas digitales a un solo byte *)
	DO_Byte2: byte;
	DO_Byte3: byte;
	DO_Byte4: byte;
	DO_Byte5: byte;
	DO_Byte6: byte;
	DO_Word_aux1: word;									(* Variables auxiliares para pasar dos bytes auxiliares de salidas digitales a un solo word *)
	DO_Word_aux2: word;
	DO_Word_aux3: word;
	DO_Word_aux4: word;
	DO_Word_aux5: word;
	DO_Word_aux6: word;
	DO_Word1: word;										(* Variables auxiliares para pasar dos bytes auxiliares de salidas digitales a un solo word *)
	DO_Word2: word;
	DO_Word3: word;
	
	
	contPLC: int:= 2;									(* Contador de éxito en la comunicación con el PLC *)

	Reserva: word;										(* Reservamos 1 registro para futuras implementaciones *)
	
	
	DO_Num: int;										(* Variable auxiliar que guarda el valor del segundo byte del comando *)
	DO_Cmd: int;										(* Variable auxiliar que guarda el valor del primer byte del comando *)
	BitVal: bool;										(* Actúa sobre las salidas digitales. 0: Reset, 1: Set *)

	Error_Comunicacion_PLC: word;						(* 2: Si se produce algún error en la comunicación PLC-Sensor. 0: Si la comunicación es correcta *)
	
END_VAR
;

(* Comienzo de la parte correspondiente al MAESTRO *)

if RTU_init = false then 					(* Se utiliza para inicializar el Maestro una sola vez *)
					
	inst1_MODBUS_MASTER_INIT( 				(* Inicializa el Maestro por Modbus RTU *)
		ENABLE:= 1, 						(* 1: Activar, 0: Desactivar *)
		MODE:= 1, 							(* 1 por defecto *)
		PORT:= 2, 							(* Puerto de entrada en serie *)
		BAUD:= 9600, 						(* Baudios del Maestro *)
		DATABITS:= 8,						(* Databits del Maestro *)
		PARITY:= 0, 						(* Paridad del Maestro, 0 = None, 1 = Odd, 2 = Even *)
		STOPBITS:= 1  						(* Stopbits del Maestro *)
			| mErrorRTU:= ERROR); 			(* 0: Si todo es correcto, !0: Error de inicialización del Maestro *)
		
		
	RTU_init:= true;						(* Cambiamos el RTU_init a true para no volver a entrar en la inicialización *)
	mCtrl:= true;							(* Cambiamos mCtrl a true para entrar en la configuración con el Enable activado *)
	
end_if;			
						
											(* De esta forma controlamos la recepción de datos, para evitar que se sature en caso de *)
	if mDone = true then					(* que el tiempo de ciclo del programa sea menor que el tiempo de lectura de datos *)
	
		mCtrl:= false;						(* Asignamos a mCtrl un false mientras se esté ejecutando la recepción de datos *)
		if contPLC >  32766 then		(* Si lega hasta el final, vuelve a empezar en 2, dejando el 0 y el 1 para manejo de errores *)
			contPLC:= 2;
		end_if;					
		contPLC:= contPLC + 1;				(* Incrementamos el contador de comunicación con el PLC cada vez que la lectura Modbus sea exitosa *)
			
							
    else 	
		mCtrl:= true;						(* Le volvemos a asignar true cuando la ejecución haya terminado *)
	end_if;
				
		
	inst2_MODBUS_MASTER_CTRL(				(* Ejecutamos la recepción de datos del Maestro *)
		ENABLE:= mCtrl,	  					(* Habilita o deshabilita la recepción de datos. Activado por flanco de subida *)
		PORT:= 2, 							(* Configuración de puerto. 1: RS232，2: RS485*)
		SLAVEID:= 123, 						(* ID del esclavo *)
		READWRITE:= 0, 						(* 0: Lecutra，1: Escritura *)
		ADDRESS:= 16#40001,  				(* Dirección del PLC，por ejemplo ：0x40001. La Depende de si es  *)
		COUNT:= 14,  						(* Número de registros leídos *)
		DATA_PTR:= data_Ptr					(* Puntero que apunta al flujo de datos *)  
			| mDone:= DONE,					(* 0: ejecutando，1: ejecución finalizada *)
			  mErrorRTU:= ERROR); 			(* 0: Si todo es correcto, !0: Error de inicialización o ejecución de Maestro *)


	data_Ptr:= &modbusBuf; 					(* Almacenamos en un buffer los valores que nos llegan del anemómetro *)


	if mErrorRTU > 0 then
		err:= mErrorRTU;					(* Escribimos en la variable err el valor de la salida de error de la función *)
		contPLC:= 0;						(* Ponemos el contador a 0 cuando hay un error *)
	end_if;	
		



(* Comienzo de la parte correspondiente al ESCLAVO *)

if TCP_Init = false then 					(* Se utiliza para inicializar el Esclavo una sola vez *)
		
	inst1_MODBUS_TCP_SLAVE_INIT( 			(* Inicializa el Esclavo por Modbus TCP *)
		ENABLE:= 1, 						(* 1: Activar, 0: Desactivar *)
		MODE:= 1, 							(* 1 por defecto *)
		ADDRESS:= 255, 						(* Device ID. Tiene que corresponder con el que ponemos en Modscan *)
		NETNUMBER:= 1 						(* 1 por defecto *)
			| mConfirmTCP:= CONFIRM, 		(* 0: inicializando，1: inicialización finalizada *)
			  mErrorTCP:= ERROR, 			(* 0: Si todo es correcto, !0: Error de inicialización del Esclavo *)
			  mErrorinfoTCP:= ERRORINFO);	(* 0: Si todo es correcto, !0: Error de inicialización del Esclavo *)

	TCP_init:= true; 						(* Cambiamos el TCP_init a true para no volver a entrar en la inicialización *)
		
end_if;



	
(* Guardamos en el array de lectura los 14 registros con los datos del anemómetro *)
		
		
(* Filtrado Digital de la Velocidad del Viento *)


	alpha:= 0.0005;
	alpha_1:= (1.0 - alpha);
	
	filtro[0]:= WORD_TO_REAL(modbusBuf[1]) * 0.36;						(* Velocidad del viento actual en km/h *)
	modbusAIBuf[0]:= REAL_TO_WORD(filtro[0] * 10.0);					(* Registro 1 - Velocidad del viento actual en km/h * 10 *)

	for i:= 1 to 5 by 1 do 
		j:= i-1;
		filtro[i]:= (alpha * filtro[j]) + alpha_1 * filtro[i];
		modbusAIBuf[i]:= REAL_TO_WORD(filtro[i] * 10.0);				(* Registros 2, 3, 4, 5 y 6 - Velocidad del viento filtrada de 1 a 5 minutos en km/h *10 *)
		
	end_for;
		
	modbusAIBuf[6]:= modbusBuf[7];										(* Registro 7 - Reservado *)
	modbusAIBuf[7]:= modbusBuf[8];										(* Registro 8 - Reservado *)
	modbusAIBuf[8]:= REAL_TO_WORD(WORD_TO_REAL(modbusBuf[9]) * 1.0); 	(* Registro 9 - Warning Wind Speed *)
	modbusAIBuf[9]:= REAL_TO_WORD(WORD_TO_REAL(modbusBuf[10]) * 1.0); 	(* Registro 10 - Alarm Wind Speed *)
	modbusAIBuf[10]:= modbusBuf[11]; 									(* Registro 11 - Warning Wind Speed Source *)
	modbusAIBuf[11]:= modbusBuf[12];									(* Registro 12 - Alarm Wind Speed Source *)
	modbusAIBuf[12]:= modbusBuf[13];									(* Registro 13 - Contador de éxito en la comunicación con el sensor (Wrap Around) *)
	modbusAIBuf[13]:= modbusBuf[14];									(* Registro 14 - Status Register de la comunicación con el sensor de viento *)
		
		
(* Ignoramos el Wind Speed Source *)
	
	if(modbusAIBuf[1] <= modbusAIBuf[8]) then							(* Direccionado a DI2 *)
		Warning_Wind_Speed_OK:= 2;										(* Valdrá 2 (bit 2) mientras la velocidad del viento filtrada 1 minuto no supere 15.9 km/h *)
	else 
		Warning_Wind_Speed_OK:= 0;										(* Valdrá 0 cuando el Warning se active *)
	end_if;
	
	if(modbusAIBuf[2] <= modbusAIBuf[9]) then							(* Direccionado a DI3 *)
		Alarm_Wind_Speed_OK:= 4;										(* Valdrá 4 (bit 3) mientras la velocidad del viento filtrada 2 minutos no supere 18.9 km/h *)
	else 
		Alarm_Wind_Speed_OK:= 0;										(* Valdrá 0 cuando la Alarma se active *)
	end_if;
							

(* Registros desde el PLC *)


(* Registro 15 - Contrador de éxito en la comunicación con el PLC *)

	modbusAIBuf[14]:= int_TO_WORD(contPLC);
	
(* Registro 16 - Status Register de la comunicación con el PLC *)
	
	if contPLC < 2 then
		Error_Comunicacion_PLC:= 2;
	else
		Error_Comunicacion_PLC:= 0;	
	end_if;
		
	modbusAIBuf[15]:= modbusAIBuf[15] AND 16#FFF8;
	modbusAIBuf[15]:= modbusAIBuf[15] OR Error_Comunicacion_PLC;												(* Por definir *)
	
	
		
(* Registros 17, 18, 19, 20 - Guardan las entradas de hasta 8 módulos de 8 entradas digitales (64 bits) *)
	
	DI_Word_aux1:= BYTE_TO_WORD(DI_Modulo1);
	DI_Word_aux1:= DI_Word_aux1 AND 16#F9;											(* Todo 1 salvo los bits 2 y 3 *)
	DI_Word_aux1:= DI_Word_aux1 OR Warning_Wind_Speed_OK OR Alarm_Wind_Speed_OK;	(* Colocamos en los bits 2 y 3 los valores de Warning_Speed_OK y Alarm_Speed_OK *)
	DI_Word_aux2:= BYTE_TO_WORD(DI_Modulo2);
	DI_Word1:= SHL (DI_Word_aux2, 8);
	DI_Word1:= DI_Word1 OR DI_Word_aux1;
	modbusAIBuf[16]:= DI_Word1;
	
	DI_Word_aux3:= BYTE_TO_WORD(DI_Modulo3);
	DI_Word_aux4:= BYTE_TO_WORD(DI_Modulo4);
	DI_Word2:= SHL (DI_Word_aux4, 8);
	DI_Word2:= DI_Word2 OR DI_Word_aux3;
	modbusAIBuf[17]:= DI_Word2;
	
	DI_Word_aux5:= BYTE_TO_WORD(DI_Modulo5);
	DI_Word_aux6:= BYTE_TO_WORD(DI_Modulo6);
	DI_Word3:= SHL (DI_Word_aux6, 8);
	DI_Word3:= DI_Word3 OR DI_Word_aux5;
	modbusAIBuf[18]:= DI_Word3;
	
	DI_Word_aux7:= BYTE_TO_WORD(DI_Modulo7);
	DI_Word_aux8:= BYTE_TO_WORD(DI_Modulo8);
	DI_Word4:= SHL (DI_Word_aux8, 8);
	DI_Word4:= DI_Word4 OR DI_Word_aux7;
	modbusAIBuf[19]:= DI_Word4;
			

			
(* Registros 21, 22, 23 - Guardan las salidas de hasta 12 módulos de 4 salidas digitales (48 bits) *)

	DO_Byte1:= SHL (DO_Modulo2, 4);
	DO_Byte1:= DO_Byte1 OR DO_Modulo1;
	DO_Byte2:= SHL (DO_Modulo4, 4);
	DO_Byte2:= DO_Byte2 OR DO_Modulo3;
	DO_Word_aux1:= BYTE_TO_WORD(DO_Byte1);
	DO_Word_aux2:= BYTE_TO_WORD(DO_Byte2);
	DI_Word1:= SHL (DO_Word_aux2, 8);
	DO_Word1:= DO_Word1 OR DO_Word_aux1;
	modbusAIBuf[20]:= DO_Word1;
	
	DO_Byte3:= SHL (DO_Modulo6, 4);
	DO_Byte3:= DO_Byte3 OR DO_Modulo5;
	DO_Byte4:= SHL (DO_Modulo8, 4);
	DO_Byte4:= DO_Byte4 OR DO_Modulo7;
	DO_Word_aux3:= BYTE_TO_WORD(DO_Byte3);
	DO_Word_aux4:= BYTE_TO_WORD(DO_Byte4);
	DI_Word2:= SHL (DO_Word_aux4, 8);
	DO_Word2:= DO_Word2 OR DO_Word_aux3;
	modbusAIBuf[21]:= DO_Word2;
	
	DO_Byte5:= SHL (DO_Modulo10, 4);
	DO_Byte5:= DO_Byte5 OR DO_Modulo9;
	DO_Byte6:= SHL (DO_Modulo12, 4);
	DO_Byte6:= DO_Byte6 OR DO_Modulo11;
	DO_Word_aux5:= BYTE_TO_WORD(DO_Byte5);
	DO_Word_aux6:= BYTE_TO_WORD(DO_Byte6);
	DI_Word3:= SHL (DO_Word_aux6, 8);
	DO_Word3:= DO_Word3 OR DO_Word_aux5;
	modbusAIBuf[22]:= DO_Word3;
		

	
(* Registro 24 de reserva *)

	modbusAIBuf[23]:= Reserva;
	

(* Apuntamos con los punteros a la dirección de los arrays de lectura y escritura respectivamente *)
	
	AI_Ptr:= &modbusAIBuf; 
	Reg_Ptr:= &modbusRegBuf; 
	
	
if TCP_Init = true then

	
	inst2_MODBUS_TCP_SLAVE_CTRL( 			(* Ejecutamos el envío de datos al Esclavo *)
		EN_IN:= 1,							(* Habilita o deshabilita el envío de datos. 1: Activado, 0: Desactivado *)
		NETNUMBER:= 1, 						(* 1 por defecto *)
		AI_ENABLE:= 1, 						(* Habilita o deshabilita el array de registros de lectura. 1: Activado, 0: Desactivado *)
		AI_PTR:= AI_Ptr, 					(* Puntero que apunta a la dirección del array de registros de lectura *) 
		AI_LENGTH:= 24, 					(* Número de registros de lectura que van a estar disponibles *)
		REG_ENABLE:= 1,  					(* Habilita o deshabilita el array de registros de escritura. 1: Activado, 0: Desactivado *)
		REG_PTR:= Reg_Ptr, 					(* Puntero que apunta a la dirección del array de registros de escritura *) 
		REG_LENGTH:= 12 					(* Número de registros de escritura que van a estar disponibles *)
			| xDone:= DONE, 				(* 0: ejecutando，1: ejecución finalizada *)
			  xError:= ERROR);				(* Mensaje de error de inicialización o ejecución del Maestro *)
			  
end_if;



(* Recepción remota de comandos *)


(* El primer byte del comando indica si se debe hacer set o reset a la salida indicada por el segundo byte del comando *)
(* Importante tener en cuenta que la escritura de registros intercambia los bytes, es decir, ModbusRegBuf[0] corresponde al segundo byte y ModbusRegBuf[1] corresponde al primero *)

if ModbusRegBuf[1]<>0 then 					(* Solo actúa cuando el primer byte del comando no es 0 *)			
	DO_Cmd:= BYTE_TO_int(ModbusRegBuf[1]);	(* Guardamos en la variable auxiliar DO_Cmd el valor del primer byte del comando *)
	DO_Num:= BYTE_TO_int(ModbusRegBuf[0]);  (* Guardamos en la variable auxiliar DO_Num el valor del segundo byte del comando *)
	
	
	CASE DO_Cmd OF                          (* Evaluamos el valor del comando *)                                                               
		1: 									(* Si el comando vale 1 (01 en hexadecimal), hacemos un DO_Reset *)
			BitVal:= 0;                                                                                                                                                                                                                
		2:   					            (* Si el comando vale 2 (02 en hexadecimal), hacemos un DO_Set *)                                                                                            
			BitVal:= 1;
    END_CASE;								(* En otro caso no hacemos nada *)


	CASE DO_Num OF							(* Evaluamos el valor de la salida a modificar *)
		0: 									(* Si la salida vale 0 (00 en hexadecimal), DO1 hace parada remota *)
			DO_Modulo1.0:= BitVal;
			tiempo0:= T#0.1s;				(* Durante 0.1 segundos *)
		1: 									(* Si la salida vale 1 (01 en hexadecimal), DO2 hace arranque remoto *)
			DO_Modulo1.1:= BitVal;	
			tiempo1:= T#0.1s;				(* Durante 0.1 segundos *)
		2: 									(* Si la salida vale 2 (02 en hexadecimal), DO3 hace disparo remoto contra incendios en zona 1 *)
			DO_Modulo1.2:= BitVal;
			tiempo2:= T#1s;					(* Durante 1 segundo *)
		3: 									(* Si la salida vale 2 (02 en hexadecimal), DO3 hace disparo remoto contra incendios en zona 2 *)
			DO_Modulo1.3:= BitVal;
			tiempo3:= T#1s;					(* Durante 1 segundo *)
		4:									(* Si la salida vale 2 (02 en hexadecimal), DO3 hace disparo remoto contra incendios en zona 3 *)
			DO_Modulo2.0:= BitVal;
			tiempo4:= T#1s;					(* Durante 1 segundo *)
		5: 									(* Si la salida vale 2 (02 en hexadecimal), DO3 hace disparo remoto contra incendios en zona 4 *)
			DO_Modulo2.1:= BitVal;
			tiempo5:= T#1s;					(* Durante 1 segundo *)
		6: 									(* Si la salida vale 2 (02 en hexadecimal), DO3 hace disparo remoto contra incendios en zona 5 *)
			DO_Modulo2.2:= BitVal;
			tiempo6:= T#1s;					(* Durante 1 segundo *)
		7:									(* Si la salida vale 2 (02 en hexadecimal), DO3 hace disparo remoto contra incendios en zona 6 *)
			DO_Modulo2.3:= BitVal;
			tiempo7:= T#1s;					(* Durante 1 segundo *)
	END_CASE;								(* En otro caso no hacemos nada *)
		                                                   
	ModbusRegBuf[1]:= 0;					(* Ponemos el comando a 0 para indicar que ya se ha ejecutado la respuesta *)

		
end_if;

END_PROGRAM